"Buried in Time" walkthrough

This walkthrough is Copyright (c) 1995 by Michael Beemer.  All
rights reserved.  Information on points contributed by Bubba
Martin.


REVISIONS:

07/23/95 - original posting.

09/21/95 - revised description of space station to use
           intended controls for Biomass pressurization; minor
           additional notes on use of filter lens; corrected
           spelling errors; added comments on known points in
           brackets [], running total included with comments
           lists major evidence/minor evidence/puzzle points/
           research points.  (i.e., [Beginning points.  0/0/0/0])

           Notes on points contributed by Bubba Martin, and
           posted in BITPTS.TXT in the CompuServe GAMERS forum.
           I have paraphrased Bubba's comments while inserting
           them into the narrative.  As I describe events in a
           different order than Bubba, any errors on synchronizing
           point counts is mine.


GENERAL NOTES:

"Buried in Time" (BIT) has several variations of play.  There is
Adventure mode, which is the default and requires the player to
play through all aspects of the game himself.  There is an
optional Walkthrough mode, which simplifies the game by
eliminating some puzzles (and the objects that would have solved
them).  Walkthrough mode also provides an additional hint or two
at the beginning to get the player started.  In addition to
these play modes, the player can obtain a "helpmate" at one of
the game locations that will furnish color commentary during
play, and will provide hints at a point penalty.  This
walkthrough will be for Adventure mode, and will make the
personality available to you as soon as possible - I think it
makes the game much more enjoyable.

There are three rules I use in adventure gaming:

     The first rule of thumb is LOOK EVERYWHERE, EXAMINE
EVERYTHING.  It seems tedious to look up and turn in all
directions, look down and turn in all directions, and then look
forward and turn in all directions every time you take a step,
but you'll miss something sometime if you don't.  I got badly
hung up two times by getting sloppy.  I'm going to skip that in
my descriptions, but you'll want to follow through when you play
yourself - there are animations scattered throughout the game,
as well as historical insights and Easter eggs.  You'll want to
see them.

     Second rule - PICK UP EVERYTHING that isn't nailed down.
You'll probably find a use for it later.  There were only two
items I didn't find a use for, and they may have been intended
for that puzzle and points I missed.

     Third rule - SAVE OFTEN, and KEEP MULTIPLE SAVE GAMES.
There's nothing more frustrating than finding that you are
trapped somewhere, and you just wrote over the save game that
had you safe only two steps before.  I have also found that a
couple of times, the game has ignored input or not finished an
animation to present me with a critical object.  Saving and
restoring the game seems to give it the kick it needs to jar
things loose.

All movement instructions will be given as "Go XXX".  Directions
will be given in initials for brevity - U D L R F A for Up Down
Left Right Forward Away.  Away means click on a portion of the
screen to 'put away' or 'move away' from the object you're
currently looking at.  I'll separate them with dashes for better
readability.


INTRODUCTION:

You are Gage Blackwood, Agent 5 of the Temporal Security
Agency.  It is 2318, and you have just solved the plot against
time shown in "The Journeyman Project", and been hailed as a
hero.  As you get up one day, a ripple appears and your future
self, in a much-advanced time travel suit, tells you that you've
been framed for tampering with time.  He tells you that he's
"hidden more information inside you."  Your future self
transfers his suit to you, and surrenders to capture by the TSA
agent who pursued him.  Your suit automatically cloaks to hide
you during the capture, then jumps 10 years in the future to
Gage's apartment.


GAGE'S APARTMENT:

Before you forget, pull up your Files biochip and review any
information you haven't already read in the game manual.  Pay
particular attention to the TSA agent profiles.  They're the
only ones who could travel through time to plant evidence
against you - one of those pieces of trivia could be vital!
[Three research points are awarded for reading various files:
1) Jumpsuit, 2) Visard Dossier, 3) Visard Profile.  0/0/0/3]

You may also want to examine the descriptions of all of your
bio-chips, so that you are familiar with what each one can do
for you.

Go F-L to place yourself in front of the china cabinet.  There
are figurines based on "The Journeyman Project" on one shelf,
and one of them represents Agent 5.  Your future self said he
had hidden information in yourself, so move the cursor over it
and click to examine it.  Note that the cursor changes to a
magnifying glass when you move it over an object you can
examine.

The view zooms in to a closer look at the figure.  Move the
cursor over it - it becomes a pointing hand to indicate you can
activate/interact with it.  Click, and the message left for you
by yourself plays.  There are hints on how to proceed, and why
you've been targeted.

Move the cursor off the figure until it changes to an arrow
wrapped over itself.  Click, and the view will pull back to
normal (This is 'Away').

Go R-F-F-F-F-R-D.  This places you in front of Gage's desk.
Click the magnifying glass cursor on the desk to move closer for
a look.  There are several objects to examine.  Click on the
papers on the left of the desk.  They will pull up, and your
view window will be filled with text.  In each case where you
read papers, the cursor will change shape to allow you to scroll
through the document.  An eye with a down arrow scrolls down the
page; an eye with an up arrow scrolls back up.  A book with a
right arrow turns the page; a book with a left arrow turns the
page back.  A curled arrow puts the document away.

Read all of Gage's notes.  There are hints that forebode the
problems you now face, and notes on problems Gage encountered at
a couple of time jumps.  There's also a broad hint or two about
how to solve one of them.

After you put the papers down, click the magnifying glass on the
object that looks like a drumhead (trampoline?) on the right.
It turns out that this is a future answering machine.  Click on
the buttons on the left edge to play back each of your
messages.  The info seems to be all background noise, but you
never know when it might come in handy.  When you finish with
the messages, use the curled arrow to back up to normal view.

Go U-R-F-L-F-F-L-D.  This places you in front of the door to the
enviro-projector room.  The door shimmers and disappears as you
look down, and the forward arrow becomes available.

Go F-R-F-R-D.  This places you in front of a pair of seats, with
a round object sitting in one of them.  Move the cursor over it
and it becomes a hand, indicating you can pick it up.  Click to
pick up the remote control.  The hand closes and the object
takes on a more 3-D shape.  Drag the remote to the left side of
your inventory window and release the button to put it in your
null-space pocket.  This is one of the items that I didn't find
a use for; you might, and besides, it was a good chance to show
you how to pick up items.  You might get in the habit of
clicking on the magnifying glass in the middle of the inventory
list to get a description of the object.  Click on the rotating
view of the object, the magnifying glass again, or one of the
directional arrows to dismiss the item description and get your
viewscreen back.  Note that you can use the up and down arrows
in the inventory list while in 'describe' mode to scroll through
the descriptions of the items in your inventory.

Go U-L-F-L-D.  This places you in front of the enviro-projector.
Click on it to sit down in front of it, then click with the
magnifying glass to move in for a closer look.  You can drop an
environment cartridge in the center section to view it (if you
had one).  The button on the left allows you to view
pre-programmed backdrops.  The button on the right pulls up the
Interactive News Network (INN).  Review all the information in
all four stories carefully.  Some of this is vital as to what
has been done and why.  Note the commercials in front of most of
the stories.  Following the principle of "pick it up if it isn't
nailed down', write down the order codes for all products.  Some
of them may come in handy.  Note also that the INN stories have
hypertext links in the text sections at the end of the story.
Click on highlighted words (just like Windows help files) to
receive additional information on that topic.  I totally
overlooked this, and missed a vital piece of information needed
later in the game.

View and read everything, then exit the news menu.  [There are
four research points awarded for 1) Reading the Agent 5 story to
the end of the Jumpsuit entry, 2) Reading the Louvre story to
the second "High Bidder" screen, 3) Reading all the hypertext
entries in the Louvre story, 4) Reading all four sections of
text for the Symbiotry Technological Discussions story.
0/0/0/7]  Go F to stand up in front of the projector.  Go
R-F-F-R.  Wait for the door to shimmer away, then Go
F-R-F-F-F-L-F to place yourself in front of the replicator panel
for your kitchenette.  Here you can order and receive the items
you saw in the INN commercials.

Press the Power button, then the Menu button.  Skip the
auto-chef, as it will never dispense anything for you.  Choose
ShopNet, then enter one of the product codes you recorded from
the commercials.  You can either use the cursor and click on the
number buttons on the side of the display, or just type them in
from the keyboard.  Note that you can only order one of any item
at one time; also, you may only have one of any item in your
inventory at one time.  If you need more than one of an item,
you'll have to use it up and come back to get another one.

Order the translator chip and the Cheese Girl.  Both are vital.
If you want, you can order the music video sample on environment
cartridge, and then trudge it back to the projector to view it.
I know of no other use for the cartridge.

Exit ShopNet and then touch Post Box.  You can obtain the items
delivered to your postbox by clicking on the appropriate menu
items.  Each item is replicated separately, and you should pick
them up to put them in your inventory list.  [One puzzle point
is awarded for learning to use the replicator.  0/0/1/7]

Check out the description of the Cheese Girl.  It produces a
pressurized stream of cheese, and should not be used in
zero-G...  But Gage needed a propulsion source at the space
station, and noted he had found a "cheesy solution".  Bingo!
This is what we need for that puzzle.

As the space station holds our erstwhile companion, and he
spruces up the game quite a bit, let's go retrieve him first!
Pull up the Jump chip, select Jump Menu, and select Farnstein's
Lab from the list (click the radio button to highlight it).  You
must read the mission briefing before the chip will let you
jump, so click the Mission button and review the information.
Then get back to the jump menu and click Jump to leap through
time to the station.


FARNSTEIN'S LAB (Arthur):

Just as Gage's notes described, your jump coordinates were wrong,
and you are stranded in zero-G outside the station.  Note that the
suit automatically begins using your oxygen reserve.  You will
receive warnings periodically as the reserve dwindles.  If it gets
too low, you can use your Jump chip's Recall function to jump
back to the apartment (or, you can hang around, run out of air,
and die).

The Cheese Girl is your salvation here.  Drag the object out of
the inventory window and drop it at the left edge of the view
window.  The pressurized cheese squirts out, and gives you enough
momentum to send you spinning up against one of the station's
hatches.  This consumes the Cheese Girl; it automatically
disappears from your inventory.  (If you used the Cheese Girl
near the center of the view window, the thrust will move you
AWAY from the station.)  [One puzzle point is awarded for using
the Cheese Girl.  0/0/2/7]

The hatch you rammed into is sealed by globules of seal-foam.
Go D-L to look down the open corridor.  Go F-F-F-F-F to reach
the "Capacitance Array" hatch.  Touch the hatch to open it.  Go
F-F to reach the "Docking Bay" hatch.  Touch it; it will not
open until the pressure is equalized - there must be some way to
do that in here.  Go L-U to see a view of the inside hull.
There appears to be a darkened screen there.  Go F to get to it.
Touch the screen to bring up a diagram of the station.  Click
the cursor on the sections to identify them, and note which are
pressurized and which are not.

Touch the section of the diagram representing the Capacitance
Array, and the station will attempt to pressurize the area.  An
alarm sounds, and the computer announces that something is
blocking the hatch to the "Habitat Wing".  Go A-U-R-F to return
To the Docking Bay hatch, then Go R-R-F to return to the Habitat
Wing hatch.  There is a metal bar in the hatchway.  Pick it up
to remove the obstruction.

Go R-R-F-L-U-F to return to the control screen.  Touch it again
and touch the Capacitance Array portion of the diagram to
pressurize the room you are in.  You will now be allowed to
enter the Docking Bay.

Go A-U-R-F to return to the Docking Bay hatch.  Touch it to open
it.  Go F to enter the Docking Bay.

The gravity generators in the bay are out of whack, so you will
have to take an indirect route to reach the passage on the other
side.  This is essentially a maze, and I think there are dead
ends you can't escape from, so save your game in case you flub
the following pattern of steps.  Go R-F-R-F-L-F-L-L-L-F-R-R-F-
L-F-R-F.  This gets you to the other side and leaves you facing
the "Sensors" hatch.  Touch the hatch to open.  Go F.

You are greeted by the ship's A.I., Arthur.  Go F when he
invites you to.  He will introduce himself, and ask if you will
permit a detailed scan of your suit and records, as he can't
talk to you directly.  Answer "Yes" by touching it on the
screen.

After the scan, Arthur will suggest that you take a copy of him
with you - the original will die with the station, so history
will not be changed by this.  (That blank bio-chip came in handy
pretty quickly, huh?)  Answer "Yes".

Go R-R to face the "A.I. Nexus" hatch.  The section is actually
detached from the station, but overriding and blowing the hatch
will expel you to the other hatchway.  Go U, and examine the
override panel.  Enter the code Arthur gives you into the panel.
When it opens, touch the handle to blow the hatch.  After your
brief flight, touch the A.I. Nexus hatch to open it.

Once inside, there is a short puzzle to solve.  Three red dots
appear above three green ones.  These need to be exchanged to
open the cover to Arthur's core.  This is an old puzzle - you
must play "leapfrog" with the dots by touching them in the right
pattern to arrange them.  A dot may only move into an empty
hole, or jump over a single dot of the opposite color to wind up
in an empty hole.  If you flub the pattern, the puzzle will
reset so you can start over from scratch.

After you solve this, Dr. Farnstein's recording will play, and
Arthur will transfer a copy of himself to your blank bio-chip.
You may now pull Arthur up like any other chip, and he has Help
and Comment functions.  Arthur's comments are frequently funny,
and often very informative.  His Help function was less useful
for me - each hint costs 50 points, and often didn't tell me
anything I hadn't already figured out for myself.  Arthur will
also occasionally offer color commentary without being
prompted.  [One puzzle point is awarded for obtaining a copy of
Arthur.  0/0/3/7]

After the transfer, you are trapped in the A.I. Nexus.  There is
nothing to do but jump out.  Contrary to Arthur's preference, I
recommend finishing with the station, as it is the simplest of
the time zones.  You need to jump back to where you first came
in, but you'll have to go home to get another Cheese Girl first.
Pull up the Jump chip and hit the Recall button.


GAGE'S APARTMENT ("refuel"):

You should get in the habit of pulling up Arthur's biochip
display as soon as you arrive somewhere.  He'll frequently have
helpful (or not helpful, but funny) comments for you.  To get
from here to the kitchenette, Go F-F-F-F-L-F-L-F.  Get another
Cheese Girl from ShopNet.  Pull up the Jump chip and prepare to
jump back to Farnstein's Lab (read ahead a little first).


FARNSTEIN'S LAB (completion):

You should be aware of a couple of things before jumping back:

1) When you revisit a time zone, you are returning to the exact
   moment in time you originally arrived.  Therefore, everything
   is reset to its original condition, except for items you
   previously removed.  Those remain in your inventory, and can
   not be found in their original locations.  Also, Arthur
   remembers what he's already commented on, and does not offer
   the same comments again.

2) You are now under the gun - your air reserve is limited, and
   you do not have time to review the comments Arthur offers
   through his comment button.  You really don't even have the
   time to listen to his extraneous comments.  Keep plowing
   onward, or you'll run out of air.

   (You might consider running through as much as you can to
   obtain the information Arthur offers, jumping back to the
   apartment just before you run out of air, and coming back
   to finish the job.  This walkthrough will just plow on
   through.)

Okay, push the Jump button and use the Cheese Girl again after
you arrive.

Go R-D-F to reach the "Atmosphere Mining" hatch.  Touch the
hatch.  It will not open at first, but Arthur will issue an
override, and the hatch will part to allow you to enter the
elevator to the asteroid.  Go F, then touch the button labeled
with green text to ride the elevator to the tram inside the
asteroid.

The elevator ride is pretty quick.  Go R-R-D to view the
elevator hatch.  Touch it to open it.  Go F, then push the up
arrow on the tram controls to ride it into the center of the
asteroid.

You may be running low on air, but luckily there is a recharge
station here.  You'll have to replenish its supply before it can
recharge you and pressurize the section of the station you are
headed to.  Go R and examine the control panel sticking up on
the left side of the railing.  Touch "Run Mining Cycle" to
extract ice chunks from the asteroid.  After watching the
process, Go L-D to turn back to the control panel and examine it
again.  Touch "Run O2 Extraction" to remove Oxygen from the ice,
then Go A-R-R to face the recharge station.

Examine the recharge station and touch the nozzle on the right
to replenish your suit's oxygen reserve.  Note that this station
also has an H2O drain.

Go A-R-R-R to face the tram controls, then touch the up button
again to take the tram to the elevator on the other side of the
asteroid.  Go R-R twice to face the elevator.  Note that there
is an object of some kind on the wall inside the elevator.  You
need that later.

Go F to enter the elevator, and press the green-labeled button
to ride it down to the other side of the station.  On your way
out, pick up the object; Go D-R.  Grab the object (an empty
water container).  Go R to face the hatch, and touch it to open
it.

Go F-F-L-U to face the atmosphere control panel outside the
"Biomass" section.  Use the panel the same way you did the one
in the Capacitance Array, but this time, pressurize the Biomass
area.

Go A-R-D-R-D to reach the Biomass hatch.  Touch it to open it
and enter the area.  This area is now pressurized, so your
oxygen reserve is recharged and you can spend as much time here
as you want.

Arthur points out the sculpture that was tampered with.  As it
happens, that is the one you are currently facing.  Go F-F-F-L
to examine it.  Your Evidence chip detects a temporal anomaly;
pull up the chip and activate the Locate function.  Move your
cursor around the screen until it changes from a box to a cross
- this indicates that the chip has located the item it should
record as evidence.  Click to record the evidence.

In this case, the evidence is not recorded, as the alteration
cannot be detected until the sculpture is properly triggered.
Arthur notes that the sculpture will only respond to a specific
harmonic resonance.  Is there anything around to produce that?
Go D, and examine the equipment attached to the left of the rack
the sculpture is mounted on - a harmonic resonator!  Press the
green button to test the current frequency indicated on the
display.  It will return "Negative Response".  Move the cursor
to the dial, and click when it changes to a right pointing
arrow.  This will rotate the dial and change the frequency.
(This is rather sensitive; the arrow may change to a curly arrow
when you least expect it.)  Keep testing frequencies until you
get a "Positive Response".  [There is one research point awarded
for discovering the proper frequency.  0/0/3/8]

Go A-U.  While your Evidence chip is selected, touch the
sculpture again.  It will morph into a different form, and the
chip will recognize this as the temporal anomaly and
automatically record it.  The game also notifies you that you
have located the source of the anomaly and can leave at any
time.  This is true, but there is something else you need to do
to be prepared for another time zone, so don't jump out yet.
Press Review to look at the catalog of recorded evidence, and
click on the thumbnail of the evidence to see the commentary on
what it is and why it is an anomaly.  [There are one major
evidence point and 1 puzzle point awarded for revealing the
anomaly and recording it.  1/0/4/8]

You can explore the station to your heart's content from this
point on (until you have to jump out for lack of air, of
course).  You can come back as many times as you want.  You
shouldn't bother trying to visit Arthur again unless you are
curious - the copy of Arthur you are carrying with you will
become increasingly nervous about the ramifications of meeting
himself, and will activate the Jump Recall for your own good
before you can reach the Sensor bay.

Before you go, you need to return to the recharge station and
fill the water container you found.  Assuming you are still
facing the sculpture, Go L-F-D-F.  Touch the hatch to open it
and exit to the corridor.  Go L-F, touch the hatch, Go F.  Touch
the green button, Go R-R-D, touch the hatch.  Go F, touch the
down button, then Go L-L-L when the tram arrives at the center
of the asteroid.

You are now facing the recharge station.  Examine it, then drag
the water container to the blue valve.  Turn the yellow valve to
fill the container with water, then drag it back into your
inventory.  You now have everything you need from the station
(unless you want to look around), so we'll jump out from here.

The next likely spot is Chateau Gaillard.  Some of the puzzles
in the game require objects from other time periods, so we'll
have to backtrack a little.  The Chateau is as good a spot as
any to continue.  Pull up the Jump chip, select Chateau
Gaillard, read the Mission Briefing, and hit the jump button.


CHATEAU GAILLARD (hammer):

As the paper in Gage's apartment noted, someone screwed up
"royally" and gave you coordinates right in front of someone!
"Luckily" (for you anyway), the guard is immediately killed by
an arrow, so time was not altered by his seeing you.

Following your new habit, pull up Arthur's chip.  He has help to
offer, but it isn't really useful and costs 50 points.  Ignore
it, but watch for Arthur's comment button to light up as you
look around.  Press it for interesting historical commentary.

Go F-D to examine the dead guard.  The second rule says, "If it
isn't nailed down, pick it up", so drag the arrow in his back
into your inventory.  It'll come in handy later.

Go U-R-R-F-F-F-F-D-F to climb down the stairs to the first
landing.  (There are other landings in this tower, but none of
them have any doors you can open.  Arthur's comments are
interesting, and there is a guard at the bottom landing with his
back to you.  You can turn around and leave without rousing him,
but if you accept Arthur's "help" comment, the guard will
overhear him and turn around and kill you... Some help! <g>)

Go U-L-F-R to face the door to the battlements inside the
castle.  (The other door on this landing will not open.)  Touch
the door to open it and Go F.

Go R-F-F-L-F-R-D.  This will take you to the 'toilet' that some
resourceful Frenchman used to break troops into the castle.
They left their grappling hook behind, so take it.  Go
U-R-F-R-F-F-R.  This places you at back the corner of the
battlement where you came through the door.

Go F-F-F-F-L.  This puts you at the corner of the battlement.
DON'T get impatient here - wait for a catapulted boulder to come
crashing through the wall.  If you step forward too quickly,
it'll take YOU with it!  Go F-R-D-F to climb down to the ground
below.

Go R-F to reach the door of the Smithy.  Touch the door to open
it, and Go F to go inside.  Go R-D to discover a hammer in the
corner.  Pick it up; we need this in another time zone.  We also
need something from another time zone to finish the Chateau, so
to avoid further backtracking, we'll jump out from here.

Pull up the Jump chip and select "Da Vinci Studio".  Read the
Mission Briefing and Jump to the site.


DA VINCI STUDIO:

After you arrive, Go L-L-D, and touch the balcony key to unlock
the door.  The key automatically goes into your inventory.  Go U
and touch the door to open it, then Go F.  You see a silhouette
in the other tower, and your Evidence chip automatically records
that fact - there ISN'T supposed to be anyone else on the
grounds at this time of night!  [One minor evidence point is
awarded for recording the silhouette.  1/1/4/8]

Go R-R, touch the door to open it, and Go F to return to the
inside of the tower.  Go D to look at the gapping pit at your
feet - this is one of Da Vinci's elevator shafts, and the
platform is at the bottom.  Do yourself a favor and don't step
into it, okay?

Go U-R-F-L-F.  This puts you in front of a panel with two levers
and some Latin writing on it.  If you can't read Latin, pull up
your Translate chip and Activate it.  Move the cursor over the
words to read the translation in the message window.  These set
the elevator to Lock/Unlock, and Up/Down.  Set the levers to
Unlock and Up.  Go D and touch the wheel to winch the elevator
up to your level.

Go U-R-R-F-R-F-R-F-R-F.  This puts you in front of one of Da
Vinci's uncompleted paintings, and the Evidence chip detects an
anomaly.  Go L-L-D to face the anomaly - a detailed smudge made
in red paint (a footprint made after stepping in a spill
,perhaps?)  Pull up the Evidence chip and select the Locate
function.  Move the cursor over the smudge and click to record
the evidence.  [One minor evidence point is awarded for
recording the footprint.  A research point is awarded for
pulling up the evidence chip and reviewing that entry.  1/2/4/9]

Go U-F-F-L-L to face the elevator.  Go F-D-R to enter it, look
down at the turnstile, and position yourself to turn it.  Touch
the wheel to crank the elevator down to ground level.  Go U-R to
face the doorway (in this lighting, a featureless black area in
front of you).  Touch the door to open it, and Go F to enter the
grounds.

Go F-R-F-F-R-D.  This places you near the gates to the grounds,
and a coil of rope on the walkway.  This is needed elsewhere, so
pick it up.  The doors in front of you are locked, so don't
bother with them.  You can follow the walkway around to the
other tower, but the door to it is also locked, so you will need
to explore Da Vinci's workshop for other means of climbing to
the top of the tower.

Go U-R-F-F-R-F to reach the door of the workshop.  Touch to open
it, and Go F to go inside and escape those interminable
crickets!  Go F-L-F-L-F-F-F-R to enter one of the nooks in the
workshop and face part of a device Da Vinci was developing.
Pick up the 'wheel assembly' and then examine the diagram
underneath it.  The translate chip will decipher the writing for
you, and give you an idea of how many pieces you need to
collect.

Go A-D-L.  There are pegs on the floor; these are needed to hold
the components of the device together, so pick them up.  Go L
and note the bench-like object in front of you.  This is the
"jig", and will receive the pieces you collect.  Based on the
diagram, the only other piece you need is a "gear assembly".

Go U-L-F-F-F-F-L-F-R-F-R.  This takes you to the other nook in
the workshop, and in front of the gear assembly you seek.  Pick
it up.

Go R-F-L-F-R-F-F-F-F-L-D to return to the jig.  Drag the wheel
assembly onto the jig.  Notice that you cannot drop the assembly
until it is correctly positioned at the front of the jig (the
end with the shield built on).  Notice also that when the piece
is correctly positioned, its icon switches to tilt to the left -
this is how the game lets you know you're in the right spot with
the right object.  Drag the gear assembly onto the jig.  Drag
the pegs onto the jig.  Try to pick the device up, and the game
will tell you it is 'unstable'.  Drag the hammer onto the jig,
and it will hammer the pegs securely into place.  You may now
pick up the "siege cycle" you have just assembled.  [A puzzle
point is awarded for assembling the cycle.  1/2/5/9]

Go U-L-F-F-L-F-F.  This puts you in front of a small desk and a
small cabinet on the wall.  You can use your translate chip to
read the sign on the cabinet.  Then, Go D and examine the
diagram on the desk.  You cannot translate the text, but it
appears the device you are finding pieces for will allow you to
climb up a rope launched by a large catapult.  You can probably
use this to get up to the second tower...  [A research point is
awarded for studying the diagram.  1/2/5/10]

Go U-L-F-R-F-L-F to reach the door to the courtyard.  Touch the
door and Go F to enter the courtyard, and be greeted by those
NOISY crickets again!  There is a lot to examine in the
courtyard/testing grounds, but let's get straight to the
catapult we need.

Go R-F-L-F-R-R-F-F-L-F-L-F-R-R-D.  This puts you at the base of
the catapult.  There is a handle here you should turn to pivot
the catapult so it is facing the tower.  Go U-L-F to mount the
catapult and sit in front of the controls.  The two dials
control vertical and horizontal aiming.  Line the crosshairs up
with the balcony on the tower (nine times to the right and down
twice) and pull the lever in the center to launch the grappling
hook.  You will automatically dismount the catapult and step
over to the side after you successfully make contact with the
hook.

Go L-F-L.  Drag the siege cycle and drop it on the wires - I
notice that in this case, the icon does NOT tilt to indicate it
is in the right place. <Grrrr...> Touch the cycle to climb up
into it.  Go F to pedal the cycle up to the tower and climb off
on to the balcony.  [A puzzle point is awarded for riding the
cycle up.  1/2/6/10]

Go F-F-L to face the balcony door.  Go D and use the balcony key
you took from the other tower to unlock the door.  Go U and
touch the door to open it.  You see someone jumping out as you
look inside.  You can hear something bouncing off the floor -
they must have dropped something when you startled them.  (Funny
how they were just startled when the door opened, and not when
you were making all that noise with the grappling hook, cycle,
and key...)  Go F to enter the tower, and the Evidence chip
detects an anomaly.

Go R-D, and pull up the Evidence chip.  Use the Locate function
and move the cursor over what looks like a dropped page of text.
You actually find something else - an electronic camera filter!
You CAN'T leave this behind to be found - pick it up.  Since it
was obviously useful to your culprit, it might be useful to you.
Click on the lens icon in your inventory list to mount the lens
on your camera.  [A minor evidence point is awarded for
recording the presence of the lens.  A research point is awarded
for examining the lens description in your inventory list.
1/3/6/11]

Go U-F to reach a desk full of documents.  The Evidence chip
detects another anomaly - better check for it.  Go R-D to face
the notebooks.  Examine them until you find one the Evidence
chip recognizes as an anomaly and records it.  You'll find that
your Translate chip cannot decipher Da Vinci's documents - it
can read Latin, but is not equipped to recognize the mirror Latin
that he wrote in.

You'll also note that the altered document is the "Codex
Atlanticus".  It has writing that can only be detected by the
lens filter, so it would never be detected by anyone not equipped
to look for it.  So, why the alteration?  If you recall, the
"Codex Atlanticus" was one of four items auctioned for high
price to a single bidder at the Louvre.  Could someone be trying
to smuggle information by concealing it in historic objects?  [A
major evidence point and a puzzle point are awarded for
discovering the writing in the codex.  2/3/7/11]

The lens has served its purpose for the time being.  Click on
its icon in your inventory list to deactivate it.  You may note
that you can only click on this item to activate and deactivate
it; you cannot drag it from your inventory list to drop it
anywhere.  Perhaps it will become useful later...

Your Evidence chip told you that you had found the anomaly and
could leave, but once again, you have to collect an object that
you'll need in another zone before you can go.  Go A-U-R-F-R-
F-F-L.  This leaves you facing a cabinet.  Open it and look
inside.  Take the preserved heart; you can also click on the
floating eyeballs for a small bit of nonsense.

Okay, NOW you're done here.  Pull up the Jump chip and select
Chichen Itza from the menu.  Read the Mission Briefing and Jump
once more into the fray...


CHICHEN ITZA (medallion):

Go R-F-L-F to enter the temple.  Fire up your translator chip
and read all the inscriptions at the top of the surrounding
walls.  Turn back to the dials on the back wall and examine
them.  Using the translator chip to help you read them, turn
them to one of the ceremonial dates listed on the right wall.
Go A-L-D, and pick up the ceramic bowl on the floor.  Go U-L-F-D
to go outside and look at the lap of the statue.  Drag the bowl
onto the statue, and begin your journey into the underworld...
[A puzzle point is awarded for gaining entrance into the
underworld. 2/3/8/11]

We're only going to go in a little bit, until we collect
something we need elsewhere.  While you're here, Go D and
collect the skull from the skeleton at your feet.  Then, Go
U-F-D to look at the second skeleton.  It doesn't have a skull
to loot, but it does have a copper medallion by its hand.  Take
it, and we have what we came for for the time being.  Pull up
the Jump menu, and jump back to Chateau Gaillard.


CHATEAU GAILLARD (completion):

You jump back to the same instant you had before, and watch the
guard take an arrow in the back again.  What comedy!  Since you
already have the arrow, you won't find it if you examine the
guard.  We can skip some of the areas already visited, so follow
these steps to get back onto the castle grounds:

Go R-R-F-F-F-D-F to climb down the stairs.  Go U-L-F-R, touch
door, Go F to exit the tower.  Go F-F-F-F-L, and wait for the
boulder to crash through the wall.  Go F-R-D-F to climb down.

I'm going to save you some backtracking by taking you directly
to the Smithy again.  You'll find clues in another tower that
would cause you to have to jump back, visit the Smithy, get
something there, and retrace a lot of your steps.  Let's skip
all that and get right to it.

Go R-F, and touch the door, Go F to enter the Smithy.  Go
L-F-R-F-R-F to reach the forge.  Go D to examine the forge and
the items around it.  Arthur will provide commentary.  Say, one
of the bricks to the right of the forge is discolored, and you
can touch it... a key mold lies underneath.  That might come in
handy...  Arthur's comments said the forge was only hot enough
for bronze or copper... and we just picked up a copper
medallion...

Drag the medallion to the pan in the forge.  Touch the wooden
lever above the forge to pump the bellows and melt the copper.
Touch the melted copper to pour it into the mold.  Then, take
they key you've just created.  Go U-R-R-F-L-F-L-F-R to return to
the Smithy's door.  [A puzzle point is awarded for creating the
key.  2/3/9/11]

Touch the door to open it, Go F-F-F-R-F-L-F-R-F.  This puts you
at the base of the moat, and your Evidence chip detects a
temporal anomaly.  Pull up the Evidence chip, then Go L-D.  The
piece of evidence is rather obvious; select the Locate function,
drag the cursor over it, and click on it to record it.  [A minor
evidence point is awarded for recording the footprint.  A
research point is awarded for reviewing the footprint's entry in
the evidence bio-chip.  2/4/9/12]

Go R.  Say, you can Go F to wade under the moat to the other
side.  This puts you at the base of the King's tower.  Go U to
see a window directly overhead.  That grappling hook is just the
thing for this!  Save your game NOW in case you have any
difficulties in the near future.  Drag the hook to the window
and watch yourself throw the hook up.  You'll begin to climb up,
but you are seen by the tower guards.  They'll chuck a boulder
at you to dissuade you.

As soon as your direction arrow lights up, Go F to climb the
rope.  You'll have some opposition, but you'll make it up.  (If
you wait too long to start climbing, the guards will toss a COW
down on you! <g>)  Once up top, the guards come running in to
catch you.  Your only chance is to pull up your Cloak bio-chip
and Activate it before they get there.  [You will receive a
puzzle point for climbing to the tower.  2/4/10/12]

After the guards have left to search for you, Deactivate your
cloak.  Pull up Arthur again, just to have him handy.  Go
F-R-F-D to reach the front of the cabinet.  Touch it to examine
it, and you will discover a hidden panel with an impression for
a key.  The key is missing, but it looks like the one you just
made... Lucky, eh? <g>  Go A-U-L-L-F-F to get a closer look at
the tapestry.  You can move your cursor over it, and there's
*something* behind it you can press.  Click to press it, and an
elaborate set of levers of some kind are tripped.  Hope that did
something useful...

Go R-R-F-L-F-F to reach the stairwell.  You can go up, but the
door to the top of the tower is locked.  Go L-D-F to climb down
to the next landing.  Go U-L-F to reach the door to the study.
Touch the door, then Go F to enter.

Go R-F-F-R-D to look in the fireplace.  Someone has tried to
burn a letter there!  Pick it up before it's completely burned
up.  Click on the 'letter' icon in your inventory to read it.
It is cryptic Old English, but your translator chip can take
care of that for you.  Pull up the chip and activate it, and it
will translate each line as you move through the document.
Sooo... there are treasures hidden in a secret chamber, and the
"doors of the besieged castle" are mentioned.  The tapestry you
poked at had an illustration of a besieged castle, and the
mechanism you tripped was behind the doors drawn on the
tapestry.

Go U-R-F-F-F-D.  There are two journals you can read here, with
the aid of your translator chip.  They tell the tale of the
besiegment of the Chateau.  They also reveal that the blacksmith
was caught with duplicate molds of keys used in the castle, and
that the key to the hidden storage room was destroyed.  These
are the clues that would send you back to the Smithy to look for
the mold and make the key we already took care of.

Go U-R-F-F-D.  This diagram of the castle shows a unlabeled
(hidden?) chamber below the food cellar.

Go U.  You can wander around the room, but don't try opening the
other door - it leads to the main keep, and there is a guard
there ready to do his duty and kill any intruders.  Go R-R-F-L-F
to return to the door you came in.  Touch it, Go F-F-L-D-F to
walk down to the bottom of the tower.  Go U-L-F to reach the
cellar door.

Touch it to open it, and once again you are on the heels of the
culprit, who sees you and jumps out.  The Evidence chip records
the fact that there was another TSA agent where one did not
belong.  [A minor evidence point is awarded for recording the
agent's presence.  2/5/10/12]

Go F-L-F-L-D to reach the chest the rogue agent was standing in
front of.  Try your copper key, and it will unlock the chest.
The forward arrow lights up, so Go F to climb into the chest.
The trigger you tripped in the tapestry opened the false bottom,
so you climb to the storage chamber underneath.  [A puzzle point
is awarded for entering the room through the chest.  2/5/11/12]

Go D-R.  There are artifacts all over the place.  At this
particular spot, there is a chest you can touch to open.  There
are gold coins in there!  Hey, nobody'll know if you take a
couple, will they?  It is against TSA regulations, but... the
second rule applies here, so take 'em!  Go U-R-R-F.  Your
Evidence chip beeps an alert - Go R-D to look at a collection of
items.  The previous anomalies were in items bought at the
Louvre auction - we ought to check out the sword in the middle
of that pile...  Pull up the Evidence chip, select Locate, and
move the cursor over the sword.  Bingo!  The diamond in the
sword is much too precise for the current time period.  [A major
evidence point and a puzzle point are awarded for making this
discovery.  3/5/12/12]

This is all we need here.  You might be a mensch and climb out
of the chamber and close the chest behind you, so the treasure
is not discovered by the invaders, but you can jump out right
now.

We've done everything but Chichen Itza, so there you jump...


CHICHEN ITZA (completion):

Let's quickly backtrack to where we got before.  Go R-F-L-F.
Examine the dials - they should be identical to what you set
them to earlier, except the date has advanced.  Turn the date
wheel up one notch.  Go A-L-D and pick up the bowl again.   Go
U-L-F-D and put the bowl in the statue's lap again.   Go F, and
you have reached the second skeleton you saw before.  It's new
stuff from here on.

Go F-F-F-F to reach a fork in the path.  You might as well take
the one on the right - Go R-F to reach the first temple.  Pull
up your Translator chip and Activate it.  Examine the glyphs
above the doorway to learn that this is the temple of the War
God.  The glyphs above the tiki face on the right say that an
offering is expected.  Examine the tiki face itself, and see
that there is a mouth that objects can be inserted into.  What
might please a war god?  Drag the bloody arrow from the Chateau
to the mouth and drop it.  The mouth "eats" it, and the door
opens.

Save your game before entering so you don't get trapped if you
run into problems inside.  Go F to enter.  The door closes
behind you.  You can open it and walk out, but then you'd have
to come up with another offering to get back in...  Look around
- there are serpent heads in alcoves to either side, and a
skeleton at your feet to the right.  That skeleton has a skull,
and it might come in handy, so take it.

Turn to the serpent on the left and click on it.  The jaws part,
and the sound of rock grinding indicates that also did something
else.  Before the jaws close again, drag one of your skulls and
drop it between them to hold them open.  Go R, and you can see
that the serpent is holding the door in front of you open.
There are spears plunging in and out of the pathway, so it would
be fatal to enter.  However, maybe the other serpent can help -
Turn to it, click on it, and drop the other skull into the jaws
before they close.  Voila!

Things get much quieter as one set of spears shuts down.
Another set is going further down the hall, so there is probably
another set of serpents to control them.  But, we're out of
skulls!  Turn to the serpent on the left and touch it to open
the jaws.  Grab the skull, Go R-F before the jaws close again
and the door shuts on you.  The timing is tricky here, so act
fast!

Note that a doorway beyond the second bank of spears closes at
the same time as the one behind you.  You'll have to find a way
to stop the spears and open that second doorway.  Go F to the
spears, and you will find another pair of serpents.  This time,
Go L and touch the serpent, then drop the skull into its jaws
before they close.  This serpent stops the spears - what
blissful quiet!

Go R-F.  The doorway is closed, so look around for something to
help you.  Some poor soul was impaled on the spears who knows
how long ago, and his skull was severed at the neck.  Take it
and put it in the other serpent's jaws.  This opens the doorway
you came in, but not the one on the far side of the temple.
Hmmm.  It looks like we have to play "juggle the skulls".  Take
the skull from the serpent that stopped the spears.  Walk back
to the entry way.  Place it between the jaws of the serpent that
held the doors open.  Return to the second pair of serpents, and
take the skull from the one serpent and put it in the other.
Voila!  All the spears are stopped, and all the doors are
open!!

Go R-F-F-F to reach the altar of the war god.  Go D, and take
the obsidian block you find there.  Go U-R-R-F-F-F-F-F to reach
the door of the temple.  Touch the door to open it, then Go F-F
to return to the fork in the path.  [A puzzle point is awarded
for obtaining the obsidian block.  3/5/13/12]

We may as well continue on to the next temple in line.  Go F-F
to hop the pillars and stand in front of the temple of the water
god.  The translator will identify it for you, and you can make
an offering from the water container you filled at the space
station.  The door will open.  Go F-F-F to reach the edge of a
footbridge over a deep gorge.  The entrance to the temple is on
the other side, but it is off to the side. (???)

Go F-F to walk across to the far end of the bridge.  Arthur
comments on the strange construction, and the trip across
demonstrates that the bridge is in separate sections, suspended
from the top...  Weird.  Go R to take a look at the temple
entrance.  Seeing no way to get over to the temple, Go R-F to
walk back across the bridge.  Wait, what's that noise behind
you?  Go R-R to see the sections of the bridge swinging wildly.
Oh - the inscription said that one had to "cross ... on the
stepping stones of faith" to get to the temple...  Hope you're
not afraid of heights!  Save your game here in case you make a
misstep and take a dive into the gorge below.

The view will begin turning to watch the section in front of
you.  When it is synchronized enough for you to step onto it,
the forward arrow will light.  You still have to time it
yourself to hop onto the platform instead of dropping to your
death in the gorge.  I recommend saving your game frequently
during this trek.  A separate file is good for this, in case you
get yourself in an untenable position and have to start over
from the beginning.

Once you reach the other side and your heart starts again, Go
F-F to reach the altar of the water god.  Go D and take the
limestone block on his altar.  You can either turn around and
retrace your steps over the "bridge of death" or say "forget
that noise!" and Jump back to your arrival site at Chichen
Itza.  Either way, make your way back to the fork in the path,
and I'll pick up from there...  [A puzzle point is awarded for
obtaining the limestone block.  3/5/14/12]

Okay, back at the fork.  Turn so that the war god is on your
right, water god on your left, and unexplored path before you.
Go F to reach another fork in the path.  A temple stands
directly ahead of you, but Go L to face the other one from this
fork, then Go F to stand in front of it.  The translator will
identify this as the temple of the wealth god, and the note that
all who approach must "turn their backs to worldly possessions
and lower their heads in humility".

Examine the tiki mouth and drop the gold coins from the Chateau
into it.  It will close and the door will open.  Oddly enough,
the coins return to your inventory - I guess you didn't put ALL
of them in, but what the wealth god doesn't know won't hurt him,
right?  Go F-F-F to reach the base of a rope bridge across the
gorge.  A doorway with golden walls lies on the other side of
the bridge.

But wait!  If you follow the first rule and look everywhere at
everything, and follow the clue to "turn your back to worldly
possessions and lower your head in humility", you will turn away
from the golden doorway and look downward.  The golden door is
actually a deathtrap - the door will close, and will not open
until you have rotted into a skeleton.  Go R-D; notice how there
is an extra anchor set into the stone?

Drop the coil of rope you found at Da Vinci's Studio on the
anchor, and it will be tied off on it.  You may now Go F to
climb down the rope to the REAL temple, below you on the cliff
face.  Go F-F to reach the altar of the wealth god.  Go D and
take the jade block from the altar.  Go U-R-R-F-F to return to
the mouth of the temple.  Go R-U-F to climb back up to the base
of the bridge.  Go F-F twice to reach the door to the temple.
Touch it, Go F-F-L-F to reach the door to the last temple - the
temple of the god of death.  [A puzzle point is awarded for
obtaining the jade block.  3/5/15/12]

The Evidence chip detects an anomaly.  Go D.  Pull up the chip
and select Locate, then click the cursor on the untidy mess on
the ground at the tiki's feet.  The chip records the evidence -
glass fragments not from this period.  Go U, and examine the
mouth of the tiki.  It is much larger, and the inscription above
it says to complete the pyramid - this requires the blocks you
removed from the other three temples.  Drag each to the mouth,
and when the third is inserted, the door will open.  For some
reason, the blocks are returned to your inventory.  [A minor
evidence point is awarded for recording the glass fragments.
3/6/15/12]

Go F-F-F-F-D to examine the sacrificial altar.  The Evidence
chip detects another anomaly.  Pull it up and do the Locate bit;
you'll find the anomaly in the bloody pool on the left -
synthetic blood!  The altar is awaiting a bloody sacrifice -
what do you have that might fit the bill?  How about the organ
you took from Da Vinci?  Drop the heart in the bloody bowl, and
Voila! - the Toltec ceremonial coffer bought at the auction
appears from the other bowl.  [A minor evidence point is awarded
for recording the presence of the synthetic blood.  3/7/15/12]

The Evidence chip pipes up again, but checking the coffer
reveals that the evidence cannot be recorded until it is
exposed.  You're going to have to open the coffer.  Save your
game here!  If you recall the historical notes, the coffer has
poisoned needles that will kill anyone trying to open it without
entering the proper combination on the symbols on the face.

Turn on your Translate chip, and use it as you turn the symbols
to form the combination.  If you recall, the inscriptions inside
the temple on the surface said that whoever touched the Holy
Vessel would become...  Turn the symbols to that phrase, then
touch the right end of the coffer to open it.  The Evidence chip
kicks in and records the anomaly inside automatically.  You are
told that you can leave, but collect that rather vital piece of
evidence first.  Then use the Jump chip Recall function to
return to your apartment.  [A major evidence point and a puzzle
point are awarded for obtaining the environment cartridge.
4/7/16/12]


GAGE'S APARTMENT (review evidence):

You just retrieved an environment cartridge, and what better
place to view it than the environment projector in your home?
Go R-R-F-R-D-F-R-F-F-L-D.  Touch the projector and examine it to
move closer to it.  Drag the new environmental cartridge to the
center of the projector control, and cartridge automatically
begins playing.

The playback halts immediately, with the message that the
cartridge is designed to be viewed in the "Kliegman radiation
band".  Hmmmm.  The video is not in the visible spectrum;
neither was the writing on the Da Vinci codex - perhaps the same
lens that let you read the writing will let you watch the
recording?  Click on the filter lens icon in your inventory to
re-activate it.  Play the cartridge in the projector again to
view the video.  [A research point is awarded for discovering
the alien spectrum the cartridge is recorded in.  4/7/16/13]

The cartridge reveals the who and the what of the plot.  One of
your fellow TSA agents was indeed smuggling information out
through the historical artifacts - information on how to build a
time machine!  While you are viewing, the culprit jumps in and
zaps you, saying, "Sorry, Gage, I need that back."


CULPRIT'S LAIR:

When you wake up, you are completely immobilized, while the
villain does the obligatory service of telling you everything
about the plot, including why YOU were framed, before
mind-wiping you.  The villain's reasoning is typically
pudding-headed, including their actually believing their alien
contact when told the information would be shared with others!
Yeah, RIGHT...  Arthur frantically tries to find a pathway out
to stymie the villain, eventually succeeding with the exception
of a password you must supply.  Recall your files on this agent,
and the one topic that was mentioned repeatedly about them.
Enter the correct password, and Arthur leaps through the net to
short out the villain's systems, causing a wild jump by their
suit.  [A puzzle point is awarded for entering the correct
password.  4/7/17/13]

Unfortunately, Arthur sacrifices himself by this act, leaving
you without companion or hint source for the remainder of the
game.  So long, Arthur, we knew ye well... <sniff!>

The power systems in the silo are completely shorted out, and
you have no jump chip to leave, or to retrieve Arthur again.
Start poking around.  Go R-R-F-F-D.  A glowing blue object looks
promising; pick it up.  It is a charged fusion generator core.
Go U-R-R-F-D.  This is an unpowered fusion generator.  Examine
the left side of the device, and press the eject button to
remove the spent generator.  Drag the burned out core to your
inventory, and drag the charged core to the device.  Voila!  You
have power again!

Go U-R-R-F-F-R-F to stand in front of the plasma tool.  Touch it
to pull its control panel up.  Touch the up and down arrows to
scroll through the list of objects it is programmed to create -
these were what the culprit used to gain access to various
artifacts.  One item is new, "transport code".  Touch "Run
Program" to temporarily create the transport code - write it
down.  Repeat the process until you have the entire code
recorded.

Go R to face the bulletin board.  There is a post-it note with a
couple of... environmental factors (?) recorded on it.  Make a
note of these.  There is a black rectangle in the center of the
board that turns out to be an INN display screen.  Review the
INN news stories for any new clues.  You will discover that the
story on the Symbiotry Technology Discussions has been altered;
a new section has been added to the beginning, describing the
withdrawal of one of the alien ambassadors from the talks.
Hmmm.  That might be suspicious.  Page back to the text section,
and check the hypertext link for the race of the ambassador in
question - the Krynn.  Their entry corresponds to the
environmental data on the post-it note - substantiating your
suspicions.  Note the three digit "alien code" at the end of the
report for future use.  Exit the news menu.  [A research point
is awarded for reading the post-it note.  Another is awarded for
viewing the new material on the Krynn in the INN story.
4/7/17/15]

Go R-F-L-F-R-R to face the transporter device used by the
culprit to transport the environment cartridge.  Save your game
here.  Touch the face of it to pull down its control screen.
Enter the transport code you recorded from the plasma tool; do
NOT press the ENTER key when you are done.  The screen will
reply that this is a diplomatic area, and prompt you for an
"alien code".  If you had pressed ENTER earlier, it would have
accepted that as the entry for the alien code.  Enter the code
you got from the INN hypertext link.  The machine will open.  Go
F to step inside and be teleported to the alien's embassy.  [A
puzzle point is awarded for successfully teleporting to the
correct location.  4/7/18/15]


KRYNN EMBASSY:

If you arrive at the other end of the teleport, and are
completely blind and paralyzed, restore your game to the point I
advised.  The Krynn environment has different light wavelengths
humans cannot see, but the lens filter you picked up in Da
Vinci's Studios will allow you to see these wavelengths.  If you
had left the filter on like I advised, this would not be a
problem, but just click on its icon again to re-attach it to
your suit.  Then, repeat the transport process to arrive in the
embassy with full vision.

If you turn around within the transport pod you arrive in, you
will hear a warbled noise - this is Krynn speech.  Pull up your
translate chip and turn back to that position - the message
states that your transporter is set for organic and inorganic
matter.  Good thing too, as you couldn't survive here if you had
arrived without your suit!

Go F to reach an alien console.  There are a few buttons here,
but they do nothing useful for you.  Go F-R-R to face the way
you came.  A display edges into view from the ceiling; examine
it.  The translator chip will report that the readings indicate
that the transporters to the left and right of the one you
arrived in are set for inorganic matter only.  If you attempt to
use either, your suit will be transported from around you,
drowning you in the Krynn underwater environment.

Go A-R-F-R-F to reach a junction in the corridor.  Save your
game here.  If you turn to the left, a membrane will open
revealing a pair of aliens further down the hall.  You may enter
that hallway, which will bring you face to face with the aliens,
and the game will essentially ignore all controls from that time
on.  This is a bug; the game should actually show you a "you've
been captured" screen that amounts to getting killed as far as
the game is concerned.  Ignore the left passageway.

Go R, and another membrane will open to reveal another pair of
aliens down the hall.  You cannot move at this point, and if you
do nothing for a while, the aliens will come down the hall and
capture you.  Select your Cloak chip and Activate it, and you
will be undetected by the aliens.  They will come down the hall
on their rounds, and the wake of their movement will brush you
aside without alerting them.

After the aliens pass, Deactivate your cloak.  You still can't
move down the hall on your own power, but you can touch the
cluster of cabling at the base of the ring in front of you.
This will trigger the alien corridor transit system, and you
will be pulled down the hall by peristaltic motion.  When you
stop, repeat the action to be pulled into the storage chamber at
the other end of the corridor.

Go F to approach a spherical node on a series of supports.
Touch it, and a membrane parts to reveal... something inside...
maybe an environment cartridge?  If so, this is one of the
pieces of evidence you must retrieve to prove your innocence and
the plot to smuggle time travel information to the Krynn!  If
you circle the storage frame, you will discover all the objects
inside various nodes.  The trick is to get them all out...  You
have an explosive charge, but that will only free one item.
Perhaps there is one item that could be used to free the others?
Place the charge on the node containing the sword.  Once you
have the sword, visit all the other nodes and use the sword to
hack your way through the sealing material.  Take ALL the items
except for the Cheese Girl, and return to the mouth of the
corridor you came here through.  [A puzzle point is awarded for
obtaining all the evidence.  Bubba Martin reports:

"A game bug in this final section can deprive you of one puzzle
point.  To make sure you get all puzzle points, use the
following scheme when you first get to the Krynn's weird
contraption:

1: Save your game.  A later death won't affect restoration here.
2: Use the explosive on the sword chamber and get the sword.
3: Collect all other pieces and leave the chamber to the tunnel
   midpoint before saving again.  You can safely restore here
   if needed.

Restoring a game that was saved -in the machine chamber- and
-after the sword and other objects have been collected- will
mess things up.  In the version reviewed, it was possible to
see the sword still in its chamber by saving right after
collecting all objects, then immediately restoring."

4/7/19/15]

Touch the cabling to move to the middle of the tubing, then
touch it again to be carried through the end of the corridor.
You will be thrown against the membrane on the opposite side of
the junction, and it will open.  This is unavoidable.  You
cannot move away, and cloaking does no good, as no one comes
down the corridor to push you out of the way with their wake.
Once again, the sword will serve you in good measure.  Use it on
the cabling in the corridor ring to disrupt the transit
mechanism and seal the corridor.

Go L-F-L.  Save your game here.  Go F to face the transporter
pods.  As soon as you do, Ambassador Icarus arrives through the
organic/inorganic transporter.  He captures you, and explains
why his race wants time travel, and why you must die to achieve
that end...  He places you in the inorganic transporter to the
analysis room and pulls the lever to transport your suit from
around you.  You must act quickly, or drown without your suit.
Recall that one of the items you picked up is giving off low
level radiation that interferes with transporter beams - Pull
the burnt out fusion generator core and drop it inside the
teleporter pod.  It shorts out the pod and the reaction pushes
Icarus into the other inorganic pod.

Go F as soon as you are able.  This will place you in front of
Icarus' transporter pod.  You have no movement controls, and if
you wait too long, Icarus will break out of the pod and capture
you, ending your game.  Pull the lever on his pod to do the same
to him as he was going to to you - transport all inorganic
material from his person.  This strips him of his waldos, so
when he breaks free, all he can do is swim away.

There is nothing more for you to do here.  Go R-F to enter the
organic/inorganic transporter pod.  Go R-R to face the front of
the pod.  Pull the lever on the left to trigger the pod, and you
are sent elsewhere, where you present your evidence and prove
your innocence.  [A puzzle point is awarded for surviving to the
end and escaping with the evidence.  4/7/20/15]


ENDGAME SEQUENCE:

The endgame sequence runs - everyone is happy!!  The future is
safe!  There is no mention of Arthur, but I presume someone went
back to retrieve a copy of him before he perished for good.

I urge you to go through again and examine every location in
this game.  It is very rich, and you will enjoy the experience.

     Hope that helped!

          Mpb.

